/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
exports.id = "vendor-chunks/bson-objectid";
exports.ids = ["vendor-chunks/bson-objectid"];
exports.modules = {

/***/ "(rsc)/./node_modules/bson-objectid/objectid.js":
/*!************************************************!*\
  !*** ./node_modules/bson-objectid/objectid.js ***!
  \************************************************/
/***/ ((module) => {

eval("\nvar MACHINE_ID = Math.floor(Math.random() * 0xFFFFFF);\nvar index = ObjectID.index = parseInt(Math.random() * 0xFFFFFF, 10);\nvar pid = (typeof process === 'undefined' || typeof process.pid !== 'number' ? Math.floor(Math.random() * 100000) : process.pid) % 0xFFFF;\n// <https://github.com/williamkapke/bson-objectid/pull/51>\n// Attempt to fallback Buffer if _Buffer is undefined (e.g. for Node.js).\n// Worst case fallback to null and handle with null checking before using.\nvar BufferCtr = (() => { try { return _Buffer; }catch(_){ try{ return Buffer; }catch(_){ return null; } } })();\n\n/**\n * Determine if an object is Buffer\n *\n * Author:   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>\n * License:  MIT\n *\n */\nvar isBuffer = function (obj) {\n  return !!(\n  obj != null &&\n  obj.constructor &&\n  typeof obj.constructor.isBuffer === 'function' &&\n  obj.constructor.isBuffer(obj)\n  )\n};\n\n// Precomputed hex table enables speedy hex string conversion\nvar hexTable = [];\nfor (var i = 0; i < 256; i++) {\n  hexTable[i] = (i <= 15 ? '0' : '') + i.toString(16);\n}\n\n// Regular expression that checks for hex value\nvar checkForHexRegExp = new RegExp('^[0-9a-fA-F]{24}$');\n\n// Lookup tables\nvar decodeLookup = [];\ni = 0;\nwhile (i < 10) decodeLookup[0x30 + i] = i++;\nwhile (i < 16) decodeLookup[0x41 - 10 + i] = decodeLookup[0x61 - 10 + i] = i++;\n\n/**\n * Create a new immutable ObjectID instance\n *\n * @class Represents the BSON ObjectID type\n * @param {String|Number} id Can be a 24 byte hex string, 12 byte binary string or a Number.\n * @return {Object} instance of ObjectID.\n */\nfunction ObjectID(id) {\n  if(!(this instanceof ObjectID)) return new ObjectID(id);\n  if(id && ((id instanceof ObjectID) || id._bsontype===\"ObjectID\"))\n    return id;\n\n  this._bsontype = 'ObjectID';\n\n  // The most common usecase (blank id, new objectId instance)\n  if (id == null || typeof id === 'number') {\n    // Generate a new id\n    this.id = this.generate(id);\n    // Return the object\n    return;\n  }\n\n  // Check if the passed in id is valid\n  var valid = ObjectID.isValid(id);\n\n  // Throw an error if it's not a valid setup\n  if (!valid && id != null) {\n    throw new Error(\n      'Argument passed in must be a single String of 12 bytes or a string of 24 hex characters'\n    );\n  } else if (valid && typeof id === 'string' && id.length === 24) {\n    return ObjectID.createFromHexString(id);\n  } else if (id != null && id.length === 12) {\n    // assume 12 byte string\n    this.id = id;\n  } else if (id != null && typeof id.toHexString === 'function') {\n    // Duck-typing to support ObjectId from different npm packages\n    return id;\n  } else {\n    throw new Error(\n      'Argument passed in must be a single String of 12 bytes or a string of 24 hex characters'\n    );\n  }\n}\nmodule.exports = ObjectID;\nObjectID.default = ObjectID;\n\n/**\n * Creates an ObjectID from a second based number, with the rest of the ObjectID zeroed out. Used for comparisons or sorting the ObjectID.\n *\n * @param {Number} time an integer number representing a number of seconds.\n * @return {ObjectID} return the created ObjectID\n * @api public\n */\nObjectID.createFromTime = function(time){\n  time = parseInt(time, 10) % 0xFFFFFFFF;\n  return new ObjectID(hex(8,time)+\"0000000000000000\");\n};\n\n/**\n * Creates an ObjectID from a hex string representation of an ObjectID.\n *\n * @param {String} hexString create a ObjectID from a passed in 24 byte hexstring.\n * @return {ObjectID} return the created ObjectID\n * @api public\n */\nObjectID.createFromHexString = function(hexString) {\n  // Throw an error if it's not a valid setup\n  if (typeof hexString === 'undefined' || (hexString != null && hexString.length !== 24)) {\n    throw new Error(\n      'Argument passed in must be a single String of 12 bytes or a string of 24 hex characters'\n    );\n  }\n\n  // Calculate lengths\n  var data = '';\n  var i = 0;\n\n  while (i < 24) {\n    data += String.fromCharCode((decodeLookup[hexString.charCodeAt(i++)] << 4) | decodeLookup[hexString.charCodeAt(i++)]);\n  }\n\n  return new ObjectID(data);\n};\n\n/**\n * Checks if a value is a valid bson ObjectId\n *\n * @param {String} objectid Can be a 24 byte hex string or an instance of ObjectID.\n * @return {Boolean} return true if the value is a valid bson ObjectID, return false otherwise.\n * @api public\n *\n * THE NATIVE DOCUMENTATION ISN'T CLEAR ON THIS GUY!\n * http://mongodb.github.io/node-mongodb-native/api-bson-generated/objectid.html#objectid-isvalid\n */\nObjectID.isValid = function(id) {\n  if (id == null) return false;\n\n  if (typeof id === 'number') {\n    return true;\n  }\n\n  if (typeof id === 'string') {\n    return id.length === 12 || (id.length === 24 && checkForHexRegExp.test(id));\n  }\n\n  if (id instanceof ObjectID) {\n    return true;\n  }\n\n  // <https://github.com/williamkapke/bson-objectid/issues/53>\n  if (isBuffer(id)) {\n    return ObjectID.isValid(id.toString('hex'));\n  }\n\n  // Duck-Typing detection of ObjectId like objects\n  // <https://github.com/williamkapke/bson-objectid/pull/51>\n  if (typeof id.toHexString === 'function') {\n    if(\n      BufferCtr &&\n      (id.id instanceof BufferCtr || typeof id.id === 'string')\n    ) {\n      return id.id.length === 12 || (id.id.length === 24 && checkForHexRegExp.test(id.id));\n    }\n  }\n\n  return false;\n};\n\nObjectID.prototype = {\n  constructor: ObjectID,\n\n  /**\n   * Return the ObjectID id as a 24 byte hex string representation\n   *\n   * @return {String} return the 24 byte hex string representation.\n   * @api public\n   */\n  toHexString: function() {\n    if (!this.id || !this.id.length) {\n      throw new Error(\n        'invalid ObjectId, ObjectId.id must be either a string or a Buffer, but is [' +\n          JSON.stringify(this.id) +\n          ']'\n      );\n    }\n\n    if (this.id.length === 24) {\n      return this.id;\n    }\n\n    if (isBuffer(this.id)) {\n      return this.id.toString('hex')\n    }\n\n    var hexString = '';\n    for (var i = 0; i < this.id.length; i++) {\n      hexString += hexTable[this.id.charCodeAt(i)];\n    }\n\n    return hexString;\n  },\n\n  /**\n   * Compares the equality of this ObjectID with `otherID`.\n   *\n   * @param {Object} otherId ObjectID instance to compare against.\n   * @return {Boolean} the result of comparing two ObjectID's\n   * @api public\n   */\n  equals: function (otherId){\n    if (otherId instanceof ObjectID) {\n      return this.toString() === otherId.toString();\n    } else if (\n      typeof otherId === 'string' &&\n      ObjectID.isValid(otherId) &&\n      otherId.length === 12 &&\n      isBuffer(this.id)\n    ) {\n      return otherId === this.id.toString('binary');\n    } else if (typeof otherId === 'string' && ObjectID.isValid(otherId) && otherId.length === 24) {\n      return otherId.toLowerCase() === this.toHexString();\n    } else if (typeof otherId === 'string' && ObjectID.isValid(otherId) && otherId.length === 12) {\n      return otherId === this.id;\n    } else if (otherId != null && (otherId instanceof ObjectID || otherId.toHexString)) {\n      return otherId.toHexString() === this.toHexString();\n    } else {\n      return false;\n    }\n  },\n\n  /**\n   * Returns the generation date (accurate up to the second) that this ID was generated.\n   *\n   * @return {Date} the generation date\n   * @api public\n   */\n  getTimestamp: function(){\n    var timestamp = new Date();\n    var time;\n    if (isBuffer(this.id)) {\n      time = this.id[3] | (this.id[2] << 8) | (this.id[1] << 16) | (this.id[0] << 24);\n    } else {\n      time = this.id.charCodeAt(3) | (this.id.charCodeAt(2) << 8) | (this.id.charCodeAt(1) << 16) | (this.id.charCodeAt(0) << 24);\n    }\n    timestamp.setTime(Math.floor(time) * 1000);\n    return timestamp;\n  },\n\n  /**\n  * Generate a 12 byte id buffer used in ObjectID's\n  *\n  * @method\n  * @param {number} [time] optional parameter allowing to pass in a second based timestamp.\n  * @return {string} return the 12 byte id buffer string.\n  */\n  generate: function (time) {\n    if ('number' !== typeof time) {\n      time = ~~(Date.now() / 1000);\n    }\n\n    //keep it in the ring!\n    time = parseInt(time, 10) % 0xFFFFFFFF;\n\n    var inc = next();\n\n    return String.fromCharCode(\n      ((time >> 24) & 0xFF),\n      ((time >> 16) & 0xFF),\n      ((time >> 8) & 0xFF),\n      (time & 0xFF),\n      ((MACHINE_ID >> 16) & 0xFF),\n      ((MACHINE_ID >> 8) & 0xFF),\n      (MACHINE_ID & 0xFF),\n      ((pid >> 8) & 0xFF),\n      (pid & 0xFF),\n      ((inc >> 16) & 0xFF),\n      ((inc >> 8) & 0xFF),\n      (inc & 0xFF)\n    )\n  },\n};\n\nfunction next() {\n  return index = (index+1) % 0xFFFFFF;\n}\n\nfunction hex(length, n) {\n  n = n.toString(16);\n  return (n.length===length)? n : \"00000000\".substring(n.length, length) + n;\n}\n\nfunction buffer(str) {\n  var i=0,out=[];\n\n  if(str.length===24)\n    for(;i<24; out.push(parseInt(str[i]+str[i+1], 16)),i+=2);\n\n  else if(str.length===12)\n    for(;i<12; out.push(str.charCodeAt(i)),i++);\n\n  return out;\n}\n\nvar inspect = (Symbol && Symbol.for && Symbol.for('nodejs.util.inspect.custom')) || 'inspect';\n\n/**\n * Converts to a string representation of this Id.\n *\n * @return {String} return the 24 byte hex string representation.\n * @api private\n */\nObjectID.prototype[inspect] = function() { return \"ObjectID(\"+this+\")\" };\nObjectID.prototype.toJSON = ObjectID.prototype.toHexString;\nObjectID.prototype.toString = ObjectID.prototype.toHexString;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/bson-objectid/objectid.js\n");

/***/ })

};
;